MODEL_ID_DEEPSEEK_CHAT_API = "deepseek-chat"
MODEL_ID_DEEPSEEK_REASONER_API = "deepseek-reasoner"
MODEL_ID_SILICONFLOW_DEEPSEEK_V3 = "Pro/deepseek-ai/DeepSeek-V3"
# MODEL_ID_SILICONFLOW_DEEPSEEK_V3 = "deepseek-ai/DeepSeek-V3"
MODEL_ID_SILICONFLOW_QWEN_2_5_14B = "Qwen/Qwen2.5-14B-Instruct"
MODEL_ID_SILICONFLOW_QWEN3_14B = "Qwen/Qwen3-14B"
MODEL_ID_CLAUDE_SONNET_4 = "claude-sonnet-4-20250514"
MODEL_ID_GITEE_QWEN3_32B = "Qwen3-32B"

MODEL_ID_SILICONFLOW_BGE_M3 = "BAAI/bge-m3"

API_MODEL = [
    MODEL_ID_DEEPSEEK_CHAT_API,
    MODEL_ID_DEEPSEEK_REASONER_API,
    MODEL_ID_SILICONFLOW_DEEPSEEK_V3,
    MODEL_ID_SILICONFLOW_QWEN_2_5_14B,
    MODEL_ID_SILICONFLOW_QWEN3_14B,
    MODEL_ID_SILICONFLOW_BGE_M3,
    MODEL_ID_GITEE_QWEN3_32B,
    MODEL_ID_CLAUDE_SONNET_4,
]

MODEL_ID_LLAMA3_8B = "meta-llama/Llama-3.1-8B-Instruct"
MODEL_NAME_LLAMA3_8B = "Llama-3.1-8B-Instruct"

MODEL_ID_DEEPSEEK_7B = "deepseek-ai/deepseek-llm-7b-chat"
MODEL_NAME_DEEPSEEK_7B = "DeepSeek-7B"

MODEL_ID_DEEPSEEK_R1_32B = "deepseek-ai/DeepSeek-R1-Distill-Qwen-32B"
MODEL_NAME_DEEPSEEK_R1_32B = "DeepSeek-R1-32B"

MODEL_ID_QwQ_32B = "Qwen/QwQ-32B"
MODEL_NAME_QwQ_32B = "QwQ-32B"

MODEL_ID_FACEBOOK_CONTRIEVER = "facebook/contriever"
MODEL_NAME_FACEBOOK_CONTRIEVER = "facebook-contriever"

MODEL_ID_CLINICAL_BERT = "Simonlee711/Clinical_ModernBERT"
MODEL_NAME_CLINICAL_BERT = "Simonlee711-Clinical_ModernBERT"

MODEL_ID_FIN_BERT = "ProsusAI/finbert"
MODEL_NAME_FIN_BERT = "ProsusAI-finbert"

@staticmethod
def get_local_model_name(local_model_id):
    model_id_to_name = {
        MODEL_ID_DEEPSEEK_7B: MODEL_NAME_DEEPSEEK_7B,
        MODEL_ID_DEEPSEEK_R1_32B: MODEL_NAME_DEEPSEEK_R1_32B,
        MODEL_ID_QwQ_32B: MODEL_NAME_QwQ_32B,
        MODEL_ID_FACEBOOK_CONTRIEVER: MODEL_NAME_FACEBOOK_CONTRIEVER,
        MODEL_ID_CLINICAL_BERT: MODEL_NAME_CLINICAL_BERT,
        MODEL_ID_FIN_BERT: MODEL_NAME_FIN_BERT,
        MODEL_ID_LLAMA3_8B: MODEL_NAME_LLAMA3_8B,
    }
    return model_id_to_name.get(local_model_id, None)

LOCAL_MODEL = [MODEL_ID_DEEPSEEK_7B, MODEL_ID_DEEPSEEK_R1_32B, MODEL_ID_QwQ_32B, MODEL_ID_LLAMA3_8B]

END_POINT_DEEPSEEK = "https://api.deepseek.com/"
END_POINT_SILICONFLOW = "https://api.siliconflow.cn/v1/"
END_POINT_CLAUDE = "https://api.anthropic.com/v1/"
END_POINT_GITEE = "https://ai.gitee.com/v1/"

END_POINT_MAP = {
    END_POINT_DEEPSEEK: [MODEL_ID_DEEPSEEK_CHAT_API, MODEL_ID_DEEPSEEK_REASONER_API],
    END_POINT_SILICONFLOW: [MODEL_ID_SILICONFLOW_DEEPSEEK_V3, MODEL_ID_SILICONFLOW_QWEN_2_5_14B, MODEL_ID_SILICONFLOW_QWEN3_14B, MODEL_ID_SILICONFLOW_BGE_M3],
    END_POINT_CLAUDE: [MODEL_ID_CLAUDE_SONNET_4],
    END_POINT_GITEE: [MODEL_ID_GITEE_QWEN3_32B],
}
